# Telegram File Uploader Bot (PHP Webhook Version)

این نسخه PHP از ربات آپلود فایل تلگرام است که با استفاده از Webhook کار می‌کند و با دیتابیس نسخه Python سازگار است.

## ویژگی‌های ربات

- ✅ آپلود و اشتراک‌گذاری فایل‌ها با لینک یکتا
- ✅ پنل مدیریت برای ادمین‌ها
- ✅ قفل کانال (الزام به عضویت در کانال‌ها)
- ✅ سیستم لایک برای فایل‌ها
- ✅ آمار تعداد کاربران و مشاهدات
- ✅ ارسال همگانی (Copy و Forward)
- ✅ مدیریت چند کانال
- ✅ سازگار با دیتابیس SQLite نسخه Python

## پیش‌نیازها

- PHP 8.1 یا بالاتر
- پسوند PDO_SQLITE فعال
- پسوند cURL فعال
- دسترسی به یک سرور با HTTPS (برای Webhook)

## نصب و راه‌اندازی

### 1. آپلود فایل‌ها

تمام فایل‌های زیر را به سرور خود آپلود کنید:
- `config.php` - تنظیمات ربات
- `database.php` - توابع دیتابیس
- `functions.php` - توابع کمکی
- `webhook.php` - مدیریت‌کننده اصلی webhook
- `setup.php` - نصب و پیکربندی اولیه

### 2. پیکربندی

فایل `config.php` را ویرایش کنید و مقادیر زیر را تنظیم نمایید:

```php
define('API_ID', YOUR_API_ID);
define('API_HASH', 'YOUR_API_HASH');
define('BOT_TOKEN', 'YOUR_BOT_TOKEN');
define('ADMIN_IDS', [YOUR_ADMIN_ID]);
define('WEBHOOK_URL', 'https://up-1.ebot.top/webhook.php');
```

### 3. اجرای Setup

برای نصب و تنظیم webhook، فایل `setup.php` را از طریق مرورگر یا خط فرمان اجرا کنید:

```bash
php setup.php
```

یا از طریق مرورگر:
```
https://up-1.ebot.top/setup.php
```

این اسکریپت:
- دیتابیس را مقداردهی اولیه می‌کند
- Webhook را تنظیم می‌کند
- اطلاعات ربات را نمایش می‌دهد

### 4. امنیت

**مهم:** پس از نصب موفق، فایل `setup.php` را حذف یا دسترسی به آن را محدود کنید:

```bash
rm setup.php
# یا
chmod 000 setup.php
```

## ساختار فایل‌ها

```
.
├── config.php          # تنظیمات و پیکربندی
├── database.php        # توابع دیتابیس (SQLite)
├── functions.php       # توابع کمکی و کیبوردها
├── webhook.php         # مدیریت‌کننده اصلی webhook
├── setup.php           # اسکریپت نصب (حذف کنید بعد از نصب)
├── bot6-real.db        # دیتابیس SQLite (ایجاد خودکار)
├── admin_states.json   # ذخیره وضعیت‌های ادمین (ایجاد خودکار)
├── error.log           # لاگ خطاها (ایجاد خودکار)
└── updates.log         # لاگ آپدیت‌ها (ایجاد خودکار در حالت دیباگ)
```

## استفاده از ربات

### برای کاربران عادی:
1. لینک اشتراک‌گذاری شده را باز کنید
2. در صورت نیاز، در کانال‌های الزامی عضو شوید
3. فایل را دریافت کنید
4. می‌توانید فایل را لایک کنید

### برای ادمین‌ها:
1. دستور `/start` را به ربات ارسال کنید
2. پنل مدیریت نمایش داده می‌شود با گزینه‌های:
   - **📦 اپلود فایل**: فایل(ها) را آپلود و لینک دریافت کنید
   - **📊 آمار ربات**: مشاهده تعداد کاربران
   - **💌 ارسال همگانی**: ارسال پیام به همه کاربران (Copy)
   - **📬 فوروارد همگانی**: فوروارد پیام به همه کاربران
   - **🔮 قفل کانال**: مدیریت کانال‌های الزامی

### آپلود فایل:
1. از پنل ادمین، گزینه "📦 اپلود فایل" را انتخاب کنید
2. فایل(ها) یا پیام(ها) را ارسال کنید
3. پس از اتمام، `/done` را ارسال کنید
4. لینک یکتا دریافت خواهید کرد

### مدیریت کانال‌ها:
1. از پنل ادمین، "🔮 قفل کانال" را انتخاب کنید
2. برای افزودن کانال جدید، "➕ افزودن کانال" را بزنید
3. Chat ID کانال را ارسال کنید (مثال: -1001234567890)
4. لینک کانال را ارسال کنید (مثال: https://t.me/yourchannel)

**نکته:** ربات باید در کانال ادمین باشد تا بتواند عضویت کاربران را بررسی کند.

### لغو عملیات:
در هر زمان می‌توانید با ارسال `/cancel` عملیات جاری را لغو کنید.

## دیتابیس

این نسخه PHP از همان ساختار دیتابیس SQLite نسخه Python استفاده می‌کند و کاملاً با آن سازگار است. می‌توانید دیتابیس موجود Python را با این نسخه استفاده کنید.

### جداول:
- **files**: اطلاعات فایل‌ها و لینک‌ها
- **users**: لیست کاربران ربات
- **channels**: کانال‌های الزامی برای عضویت
- **likes**: لایک‌های کاربران

## عیب‌یابی

### فعال کردن حالت Debug:
در `config.php`:
```php
define('DEBUG_MODE', true);
```

این کار لاگ‌های زیر را ایجاد می‌کند:
- `error.log`: خطاهای PHP
- `updates.log`: تمام آپدیت‌های دریافتی از تلگرام

### مشکلات رایج:

1. **Webhook کار نمی‌کند:**
   - مطمئن شوید URL با HTTPS است
   - بررسی کنید که `webhook.php` قابل دسترسی است
   - لاگ‌های سرور را بررسی کنید

2. **ربات پاسخ نمی‌دهد:**
   - اطلاعات webhook را بررسی کنید: `/setup.php`
   - فایل `updates.log` را برای آپدیت‌های دریافتی چک کنید
   - مطمئن شوید BOT_TOKEN صحیح است

3. **خطای دیتابیس:**
   - بررسی کنید که دایرکتوری قابل نوشتن است
   - مطمئن شوید PDO_SQLITE فعال است

4. **قفل کانال کار نمی‌کند:**
   - ربات باید در کانال ادمین باشد
   - Chat ID کانال باید صحیح باشد (منفی برای کانال‌ها)

## تفاوت‌ها با نسخه Python

1. **Webhook به جای Long Polling**: این نسخه از Webhook استفاده می‌کند (سریع‌تر و کارآمدتر)
2. **ذخیره وضعیت**: وضعیت‌های ادمین در فایل JSON ذخیره می‌شود (به جای حافظه)
3. **عدم حذف خودکار فایل‌ها**: قابلیت حذف خودکار فایل‌ها بعد از مدت معین حذف شده (می‌توانید با cron job اضافه کنید)

## امنیت

- همیشه از HTTPS استفاده کنید
- API Token و اطلاعات حساس را محرمانه نگه دارید
- دسترسی به فایل‌های `.db` و `.json` را محدود کنید
- در محیط Production، `DEBUG_MODE` را غیرفعال کنید
- بعد از نصب، `setup.php` را حذف کنید

## پشتیبانی

در صورت بروز مشکل:
1. فایل‌های لاگ را بررسی کنید
2. تنظیمات `config.php` را دوباره چک کنید
3. مطمئن شوید تمام پیش‌نیازها نصب است

## لایسنس

این پروژه آزاد و متن‌باز است.

