import asyncio
import sqlite3
import json
import random
import string

from pyrogram import Client, filters, enums
from pyrogram.types import (InlineKeyboardButton, InlineKeyboardMarkup,
                            CallbackQuery, Message)

######################
#  Configuration
######################
API_ID = 2815084   # your api_id here
API_HASH = "6e64163bfb52621e86c0d4d6137a66d1"
BOT_TOKEN = "8151782652:AAHrxTFNQMP_wS9vsAl4FfsQLdaqwpyHf4I"

# List your admin Telegram user IDs here.
ADMIN_IDS = [1389610583,1997074793,7087757135]

# Database file name:
DATABASE = "bot6-real.db"

######################
#  Database Functions
######################
def init_db():
    conn = sqlite3.connect(DATABASE)
    c = conn.cursor()
    c.execute("""
    CREATE TABLE IF NOT EXISTS files (
      id INTEGER PRIMARY KEY AUTOINCREMENT,
      link_code TEXT UNIQUE,
      file_data TEXT, -- JSON list of dictionaries with chat_id and message_id
      view_count INTEGER DEFAULT 0,
      created_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP
    )
    """)
    c.execute("""
    CREATE TABLE IF NOT EXISTS users (
      user_id INTEGER PRIMARY KEY,
      join_date TIMESTAMP DEFAULT CURRENT_TIMESTAMP
    )
    """)
    c.execute("""
    CREATE TABLE IF NOT EXISTS channels (
      chat_id INTEGER PRIMARY KEY,
      channel_link TEXT
    )
    """)
    c.execute("""
    CREATE TABLE IF NOT EXISTS likes (
      id INTEGER PRIMARY KEY AUTOINCREMENT,
      link_code TEXT,
      user_id INTEGER,
      created_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP,
      UNIQUE(link_code, user_id)
    )
    """)
    conn.commit()
    conn.close()

def add_file_record(link_code, file_data):
    conn = sqlite3.connect(DATABASE)
    c = conn.cursor()
    c.execute("INSERT INTO files (link_code, file_data) VALUES (?, ?)", (link_code, json.dumps(file_data)))
    conn.commit()
    conn.close()

def get_file_record(link_code):
    conn = sqlite3.connect(DATABASE)
    c = conn.cursor()
    c.execute("SELECT id, file_data, view_count FROM files WHERE link_code=?", (link_code,))
    row = c.fetchone()
    conn.close()
    if row:
        return {"id": row[0], "file_data": json.loads(row[1]), "view_count": row[2]}
    return None

def increment_view_count(link_code):
    conn = sqlite3.connect(DATABASE)
    c = conn.cursor()
    c.execute("UPDATE files SET view_count = view_count + 1 WHERE link_code=?", (link_code,))
    conn.commit()
    conn.close()

def add_user(user_id):
    conn = sqlite3.connect(DATABASE)
    c = conn.cursor()
    c.execute("INSERT OR IGNORE INTO users (user_id) VALUES (?)", (user_id,))
    conn.commit()
    conn.close()

def get_all_users():
    conn = sqlite3.connect(DATABASE)
    c = conn.cursor()
    c.execute("SELECT user_id FROM users")
    rows = c.fetchall()
    conn.close()
    return [row[0] for row in rows]

def get_user_count():
    conn = sqlite3.connect(DATABASE)
    c = conn.cursor()
    c.execute("SELECT COUNT(*) FROM users")
    count = c.fetchone()[0]
    conn.close()
    return count

def add_channel(chat_id, channel_link):
    conn = sqlite3.connect(DATABASE)
    c = conn.cursor()
    c.execute("INSERT OR REPLACE INTO channels (chat_id, channel_link) VALUES (?, ?)", (chat_id, channel_link))
    conn.commit()
    conn.close()

def remove_channel(chat_id):
    conn = sqlite3.connect(DATABASE)
    c = conn.cursor()
    c.execute("DELETE FROM channels WHERE chat_id=?", (chat_id,))
    conn.commit()
    conn.close()

def get_channels():
    conn = sqlite3.connect(DATABASE)
    c = conn.cursor()
    c.execute("SELECT chat_id, channel_link FROM channels")
    rows = c.fetchall()
    conn.close()
    return [{"chat_id": row[0], "channel_link": row[1]} for row in rows]

def add_like(link_code, user_id):
    conn = sqlite3.connect(DATABASE)
    c = conn.cursor()
    try:
        c.execute("INSERT INTO likes (link_code, user_id) VALUES (?, ?)", (link_code, user_id))
        conn.commit()
        return True
    except sqlite3.IntegrityError:
        # User already liked this link
        return False
    finally:
        conn.close()

def remove_like(link_code, user_id):
    conn = sqlite3.connect(DATABASE)
    c = conn.cursor()
    c.execute("DELETE FROM likes WHERE link_code=? AND user_id=?", (link_code, user_id))
    result = c.rowcount > 0
    conn.commit()
    conn.close()
    return result

def get_like_count(link_code):
    conn = sqlite3.connect(DATABASE)
    c = conn.cursor()
    c.execute("SELECT COUNT(*) FROM likes WHERE link_code=?", (link_code,))
    count = c.fetchone()[0]
    conn.close()
    return count

def has_user_liked(link_code, user_id):
    conn = sqlite3.connect(DATABASE)
    c = conn.cursor()
    c.execute("SELECT 1 FROM likes WHERE link_code=? AND user_id=?", (link_code, user_id))
    result = c.fetchone() is not None
    conn.close()
    return result

# Initialize the database
init_db()

######################
#  Helper Functions
######################
def generate_link_code(length=8):
    return ''.join(random.choices(string.ascii_letters + string.digits, k=length))

def admin_panel_keyboard():
    buttons = [
        [InlineKeyboardButton("📦 اپلود فایل", callback_data="admin_upload")],
        [InlineKeyboardButton("📊 آمار ربات", callback_data="admin_stats")],
        [InlineKeyboardButton("💌 ارسال همگانی", callback_data="admin_broadcast_copy")],
        [InlineKeyboardButton("📬فوروارد همگانی", callback_data="admin_broadcast_forward")],
        [InlineKeyboardButton("🔮قفل کانال", callback_data="admin_lockchannel")]
    ]
    return InlineKeyboardMarkup(buttons)

def channel_lock_keyboard():
    channels = get_channels()
    buttons = []
    for ch in channels:
        buttons.append([InlineKeyboardButton(f"کانال: {ch['chat_id']}", callback_data=f"channel_info_{ch['chat_id']}")])
    # Button to add a new channel
    buttons.append([InlineKeyboardButton("➕ افزودن کانال", callback_data="channel_add")])
    return InlineKeyboardMarkup(buttons)

# For users who need to join channels before getting files,
# include the link_code in the callback data.
async def  user_join_keyboard(link_code):
    channels = get_channels()
    buttons = []
    
    for ch in channels:
        # get the channel name using the chat_id
        channel_name = await app.get_chat(ch["chat_id"])
        channel_name = channel_name.title
        buttons.append([InlineKeyboardButton(f" {channel_name}", url=ch["channel_link"])])
    buttons.append([InlineKeyboardButton("عضو شدم", callback_data=f"join_check:{link_code}")])  
    return InlineKeyboardMarkup(buttons)

def file_sent_keyboard(link_code, user_id):
    like_status = has_user_liked(link_code, user_id)
    like_count = get_like_count(link_code)
    
    like_text = "❤️" if like_status else "🤍"
    like_text += f" ({like_count})"
    
    buttons = [[InlineKeyboardButton(like_text, callback_data=f"like:{link_code}")]]
    return InlineKeyboardMarkup(buttons)

# After sending the file(s), schedule deletion after 5 minutes.
async def delete_messages_after_delay(client: Client, chat_id: int, message_ids: list, delay: int):
    await asyncio.sleep(delay)
    try:
        await client.delete_messages(chat_id, message_ids)
    except Exception as e:
        print("Error deleting messages:", e)

######################
#  Global Admin State
######################
# For simple "conversation" handling for admins.
admin_states = {}  
# e.g. admin_states[admin_id] = {"mode": "upload", "files": []}

######################
#  Pyrogram Client
######################
app = Client("my_bot6-real", api_id=API_ID, api_hash=API_HASH, bot_token=BOT_TOKEN)

######################
#  /start Handler
######################
@app.on_message(filters.command("start"))
async def start_handler(client: Client, message: Message):
    user_id = message.from_user.id
    # Save non-admin users into our DB.
    if user_id not in ADMIN_IDS:
        add_user(user_id)
    
    # Check if a payload (link code) was given.
    if len(message.command) > 1:
        payload = message.command[1]
        file_record = get_file_record(payload)
        if not file_record:
            await message.reply("لینک نامعتبر است!")
            return

        # Check if any locked channels are configured.
        channels = get_channels()
        if channels:
            not_member = []
            for ch in channels:
                try:
                    member = await client.get_chat_member(ch["chat_id"], user_id)
                    if member.status in ["left", "kicked"]:
                        not_member.append(ch)
                except Exception:
                    not_member.append(ch)
            if not_member:
                await message.reply(
                    "برای دریافت فایل باید در کانال‌های زیر عضو شوید:",
                    reply_markup=await user_join_keyboard(payload)
                )
                return

        # Otherwise, send the files (copying from the original chat)
        file_data = file_record["file_data"]  # a list of dicts with chat_id and message_id
        sent_message_ids = []
        for item in file_data:
            try:
                sent = await client.copy_message(
                    chat_id=user_id,
                    from_chat_id=item["chat_id"],
                    message_id=item["message_id"]
                )
                sent_message_ids.append(sent.id)
            except Exception as e:
                print("Error sending file:", e)
        increment_view_count(payload)
        like_count = get_like_count(payload)
        # await message.reply(
        #     "این فایل بعد از یک دقیقه پاک خواهد شد",
        # )
        await message.reply(
            f"فایل ارسال شد. تعداد مشاهده: {file_record['view_count'] + 1}",
            reply_markup=file_sent_keyboard(payload, user_id)
        )

        # Schedule deletion after 5 minutes (300 seconds)
        # asyncio.create_task(delete_messages_after_delay(client, user_id, sent_message_ids, delay=60))
    else:
        # No payload – if the user is an admin, show the admin panel.
        if user_id in ADMIN_IDS:
            await message.reply("پنل ادمین:", reply_markup=admin_panel_keyboard())
        else:
            await message.reply("سلام! برای دریافت فایل، لطفاً از لینک معتبر استفاده کنید.")

######################
#  Callback Query Handler
######################
@app.on_callback_query()
async def callback_handler(client: Client, callback_query: CallbackQuery):
    data = callback_query.data
    user_id = callback_query.from_user.id

    # Like button handler
    if data.startswith("like:"):
        link_code = data.split(":", 1)[1]
        like_status = has_user_liked(link_code, user_id)
        
        if like_status:
            # User already liked, now unlike
            if remove_like(link_code, user_id):
                await callback_query.answer("لایک شما حذف شد")
        else:
            # User hasn't liked, now like
            if add_like(link_code, user_id):
                await callback_query.answer("با تشکر از لایک شما!")
            else:
                await callback_query.answer("قبلا لایک کرده‌اید!")
        
        # Update like button with new count
        await callback_query.message.edit_reply_markup(
            reply_markup=file_sent_keyboard(link_code, user_id)
        )
        return

    # Admin panel callbacks (only for admins)
    if data.startswith("admin_"):
        if user_id not in ADMIN_IDS:
            await callback_query.answer("شما اجازه دسترسی به این بخش را ندارید.", show_alert=True)
            return
        if data == "admin_upload":
            admin_states[user_id] = {"mode": "upload", "files": []}
            await callback_query.message.edit_text(
                "لطفا فایل (یا پیام) مورد نظر برای آپلود را ارسال کنید. پس از اتمام، دستور /done را بفرستید."
            )
        elif data == "admin_stats":
            count = get_user_count()
            await callback_query.answer(f"تعداد کاربران: {count}", show_alert=True)
        elif data == "admin_broadcast_copy":
            admin_states[user_id] = {"mode": "broadcast_copy"}
            await callback_query.message.edit_text("پیام مورد نظر را برای ارسال همگانی (copy) ارسال کنید.")
        elif data == "admin_broadcast_forward":
            admin_states[user_id] = {"mode": "broadcast_forward"}
            await callback_query.message.edit_text("پیام مورد نظر را برای ارسال همگانی (forward) ارسال کنید.")
        elif data == "admin_lockchannel":
            await callback_query.message.edit_text("مدیریت قفل کانال:", reply_markup=channel_lock_keyboard())
        await callback_query.answer()

    # Callback from "عضو شدم" button with the link code embedded.
    elif data.startswith("join_check:"):
        link_code = data.split(":", 1)[1]
        # Re-check membership for all locked channels.
        channels = get_channels()
        not_member = []
        for ch in channels:
            try:
                member = await client.get_chat_member(ch["chat_id"], user_id)
                if member.status in ["left", "kicked"]:
                    not_member.append(ch)
            except Exception:
                not_member.append(ch)
        if not_member:
            await callback_query.answer("هنوز عضو همه کانال‌ها نشده‌اید.", show_alert=True)
        else:
            file_record = get_file_record(link_code)
            if not file_record:
                await callback_query.answer("لینک نامعتبر است.", show_alert=True)
                return
            file_data = file_record["file_data"]
            sent_message_ids = []
            for item in file_data:
                try:
                    sent = await client.copy_message(
                        chat_id=user_id,
                        from_chat_id=item["chat_id"],
                        message_id=item["message_id"]
                    )
                    sent_message_ids.append(sent.id)
                except Exception as e:
                    print("Error sending file:", e)
            increment_view_count(link_code)
            await callback_query.message.reply_text(
                f"فایل ارسال شد. تعداد مشاهده: {file_record['view_count'] + 1}",
                reply_markup=file_sent_keyboard(link_code, user_id)
            )
            # asyncio.create_task(delete_messages_after_delay(client, user_id, sent_message_ids, delay=300))
            await callback_query.answer("فایل ارسال شد.")

    # Channel management callbacks for admins:
    elif data.startswith("channel_info_"):
        chat_id = int(data.split("_")[-1])
        channels = get_channels()
        channel = next((ch for ch in channels if ch["chat_id"] == chat_id), None)
        if channel:
            text = f"کانال:\nChat ID: {channel['chat_id']}\nLink: {channel['channel_link']}"
            buttons = [[InlineKeyboardButton("حذف کانال", callback_data=f"channel_remove_{chat_id}")]]
            await callback_query.message.edit_text(text, reply_markup=InlineKeyboardMarkup(buttons))
        else:
            await callback_query.answer("کانال یافت نشد.", show_alert=True)
    elif data.startswith("channel_remove_"):
        chat_id = int(data.split("_")[-1])
        remove_channel(chat_id)
        await callback_query.answer("کانال حذف شد.", show_alert=True)
        await callback_query.message.edit_text("کانال حذف شد.", reply_markup=channel_lock_keyboard())
    elif data == "channel_add":
        admin_states[user_id] = {"mode": "add_channel", "step": "chat_id"}
        await callback_query.message.edit_text(
            "لطفاً Chat ID کانال را ارسال کنید.\n"
            "مثال: -1001234567890"
        )

######################
#  Admin State Message Handler
######################
@app.on_message(filters.private & filters.user(ADMIN_IDS))
async def admin_state_handler(client: Client, message: Message):
    user_id = message.from_user.id
    
    # Handle /cancel command first for all states
    if message.text == "/cancel" and user_id in admin_states:
        mode = admin_states[user_id].get("mode")
        del admin_states[user_id]
        if mode == "add_channel":
            await message.reply("عملیات لغو شد.", reply_markup=channel_lock_keyboard())
        else:
            await message.reply("عملیات لغو شد.", reply_markup=admin_panel_keyboard())
        return
    
    # Handle /done command for upload mode
    if message.text and message.text.startswith('/done'):
        if user_id in admin_states and admin_states[user_id].get("mode") == "upload":
            state = admin_states[user_id]
            if not state["files"]:
                await message.reply("هیچ فایلی دریافت نشده است.")
                return
            # Generate a unique link code and save the file record.
            link_code = generate_link_code()
            add_file_record(link_code, state["files"])
            bot_username = (await client.get_me()).username
            link = f"https://t.me/{bot_username}?start={link_code}"
            await message.reply(f"فایل(ها) ذخیره شدند.\nلینک دریافت فایل:\n{link}")
            # Clean up admin state and return to admin panel
            del admin_states[user_id]
            await message.reply("پنل ادمین:", reply_markup=admin_panel_keyboard())
        else:
            await message.reply("شما در حالت آپلود نیستید.")
        return

    # Handle other admin states
    if user_id in admin_states:
        state = admin_states[user_id]
        
        # For "upload file" mode:
        if state["mode"] == "upload":
            if message.media or message.text:
                state["files"].append({"chat_id": message.chat.id, "message_id": message.id})
                await message.reply("فایل ذخیره شد.")
                
        # For broadcast modes:
        elif state["mode"] in ["broadcast_copy", "broadcast_forward"]:
            users = get_all_users()
            success = 0
            failure = 0
            for uid in users:
                try:
                    if state["mode"] == "broadcast_copy":
                        await client.copy_message(
                            chat_id=uid,
                            from_chat_id=message.chat.id,
                            message_id=message.id
                        )
                    else:
                        await client.forward_messages(
                            chat_id=uid,
                            from_chat_id=message.chat.id,
                            message_ids=message.id
                        )
                    success += 1
                except Exception as e:
                    print("Broadcast error:", e)
                    failure += 1
            await message.reply(f"ارسال همگانی انجام شد.\nموفق: {success}\nناموفق: {failure}")
            del admin_states[user_id]
            await message.reply("پنل ادمین:", reply_markup=admin_panel_keyboard())
            
        # For channel addition mode:
        elif state["mode"] == "add_channel":
            if state["step"] == "chat_id":
                try:
                    chat_id = int(message.text)
                    # Try to get chat information to verify bot's access
                    try:
                        chat = await client.get_chat(chat_id)
                        # Store chat_id and move to next step
                        state["chat_id"] = chat_id
                        state["step"] = "channel_link"
                        await message.reply(
                            "Chat ID تأیید شد. حالا لطفاً لینک کانال را ارسال کنید.\n"
                            "مثال: https://t.me/yourchannel یا @yourchannel"
                        )
                    except Exception as e:
                        print(f"Error checking channel access: {e}")
                        await message.reply(
                            "خطا: ربات به این کانال دسترسی ندارد.\n"
                            "لطفاً مطمئن شوید که:\n"
                            "1. Chat ID صحیح است\n"
                            "2. ربات ادمین کانال است\n"
                            "3. ربات به کانال دسترسی دارد\n\n"
                            "لطفاً دوباره Chat ID را ارسال کنید یا /cancel را بزنید."
                        )
                except ValueError:
                    await message.reply(
                        "لطفاً یک Chat ID معتبر ارسال کنید.\n"
                        "مثال: -1001234567890"
                    )
                
            elif state["step"] == "channel_link":
                if message.text.startswith(('https://t.me/', 'http://t.me/', '@')):
                    try:
                        channel_link = message.text
                        if channel_link.startswith('@'):
                            channel_link = f"https://t.me/{channel_link[1:]}"
                            
                        add_channel(state["chat_id"], channel_link)
                        await message.reply("✅ کانال با موفقیت اضافه شد!")
                        # Clean up state
                        del admin_states[user_id]
                        # Show updated channel lock keyboard
                        await message.reply("مدیریت قفل کانال:", reply_markup=channel_lock_keyboard())
                    except Exception as e:
                        print(f"Error adding channel: {e}")
                        await message.reply(
                            "خطا در ذخیره اطلاعات کانال. لطفاً دوباره تلاش کنید یا /cancel را بزنید."
                        )
                else:
                    await message.reply(
                        "لطفاً یک لینک معتبر کانال ارسال کنید.\n"
                        "مثال: https://t.me/yourchannel یا @yourchannel"
                    )

######################
#  Run the Bot
######################
app.run()
