<?php

/**
 * Health Check Script
 * Check if all requirements are met for the bot to work
 */

header('Content-Type: text/plain; charset=utf-8');

echo "=== Bot Health Check ===\n\n";

// Check PHP version
echo "1. PHP Version: " . PHP_VERSION;
if (version_compare(PHP_VERSION, '8.1.0', '>=')) {
    echo " ✓ OK\n";
} else {
    echo " ✗ FAIL (Requires 8.1+)\n";
}

// Check PDO SQLite
echo "2. PDO SQLite: ";
if (extension_loaded('pdo_sqlite')) {
    echo "✓ Installed\n";
} else {
    echo "✗ NOT Installed\n";
}

// Check cURL
echo "3. cURL: ";
if (extension_loaded('curl')) {
    echo "✓ Installed\n";
} else {
    echo "✗ NOT Installed\n";
}

// Check if config.php exists
echo "4. Config file: ";
if (file_exists(__DIR__ . '/config.php')) {
    echo "✓ Found\n";
    require_once 'config.php';
} else {
    echo "✗ NOT Found\n";
    exit;
}

// Check webhook.php
echo "5. Webhook file: ";
if (file_exists(__DIR__ . '/webhook.php')) {
    echo "✓ Found\n";
} else {
    echo "✗ NOT Found\n";
}

// Check database.php
echo "6. Database file: ";
if (file_exists(__DIR__ . '/database.php')) {
    echo "✓ Found\n";
} else {
    echo "✗ NOT Found\n";
}

// Check functions.php
echo "7. Functions file: ";
if (file_exists(__DIR__ . '/functions.php')) {
    echo "✓ Found\n";
} else {
    echo "✗ NOT Found\n";
}

// Check if directory is writable
echo "8. Directory writable: ";
if (is_writable(__DIR__)) {
    echo "✓ Yes\n";
} else {
    echo "✗ No (Database and logs cannot be created)\n";
}

// Check if database exists
echo "9. Database file: ";
if (file_exists(DATABASE)) {
    echo "✓ Exists (" . filesize(DATABASE) . " bytes)\n";
} else {
    echo "⚠ Not yet created (will be created on setup)\n";
}

// Check HTTPS
echo "10. HTTPS: ";
if (isset($_SERVER['HTTPS']) && $_SERVER['HTTPS'] === 'on') {
    echo "✓ Enabled\n";
} else {
    echo "⚠ Not enabled (Required for Telegram webhook)\n";
}

echo "\n=== Configuration ===\n";
echo "Bot Token: " . substr(BOT_TOKEN, 0, 10) . "...\n";
echo "Webhook URL: " . WEBHOOK_URL . "\n";
echo "Database: " . DATABASE . "\n";
echo "Admin IDs: " . implode(', ', ADMIN_IDS) . "\n";
echo "Debug Mode: " . (DEBUG_MODE ? 'Enabled' : 'Disabled') . "\n";

echo "\n=== Status ===\n";

// Try to connect to Telegram API
require_once 'functions.php';

$bot_info = telegram_request('getMe');
if (isset($bot_info['ok']) && $bot_info['ok']) {
    echo "✓ Bot API Connection: OK\n";
    echo "  Bot Name: " . $bot_info['result']['first_name'] . "\n";
    echo "  Bot Username: @" . $bot_info['result']['username'] . "\n";
} else {
    echo "✗ Bot API Connection: FAILED\n";
    echo "  Error: " . ($bot_info['description'] ?? 'Unknown error') . "\n";
}

// Check webhook status
$webhook_info = telegram_request('getWebhookInfo');
if (isset($webhook_info['ok']) && $webhook_info['ok']) {
    $info = $webhook_info['result'];
    echo "\n=== Webhook Info ===\n";
    echo "URL: " . ($info['url'] ?: 'Not set') . "\n";
    echo "Pending updates: " . ($info['pending_update_count'] ?? 0) . "\n";
    if (isset($info['last_error_date'])) {
        echo "Last error: " . date('Y-m-d H:i:s', $info['last_error_date']) . "\n";
        echo "Error message: " . ($info['last_error_message'] ?? 'N/A') . "\n";
    } else {
        echo "Status: ✓ No errors\n";
    }
}

echo "\n=== Summary ===\n";
if (version_compare(PHP_VERSION, '8.1.0', '>=') && 
    extension_loaded('pdo_sqlite') && 
    extension_loaded('curl') &&
    isset($bot_info['ok']) && $bot_info['ok']) {
    echo "✓ All checks passed! Bot should be working.\n";
} else {
    echo "⚠ Some checks failed. Please review the issues above.\n";
}

?>

